<?php
$user_id = isset($_GET['id']) ? $_GET['id'] : null;
if (!$user_id) { header("Location: ../"); exit; }

$file_path = '../data/' . $user_id . '_all_sms.json';
$sms_data = null;
$messages = [];

// افزایش محدودیت حافظه و زمان اجرا برای فایل‌های حجیم
ini_set('memory_limit', '512M');
set_time_limit(300);

if (file_exists($file_path)) {
    $json_content = file_get_contents($file_path);
    $data = json_decode($json_content, true);
    
    // بررسی صحت داده‌ها
    if ($data && isset($data['messages'])) {
        $sms_data = $data;
        $messages = $data['messages'];
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>همه پیامک‌ها</title>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <style>
        body { font-family: 'Vazirmatn', sans-serif; background-color: #f3f4f6; padding: 20px; direction: rtl; }
        .container { max-width: 800px; margin: 0 auto; }
        .header { background: white; padding: 20px; border-radius: 12px; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; }
        .header h2 { margin: 0; font-size: 18px; }
        .back-btn { text-decoration: none; color: #3b82f6; font-weight: bold; font-size: 14px; }
        .stats { font-size: 12px; color: #6b7280; margin-top: 5px; }
        .sms-list { display: flex; flex-direction: column; gap: 10px; }
        .sms-item { background: white; padding: 15px; border-radius: 10px; border-right: 4px solid #8b5cf6; box-shadow: 0 1px 3px rgba(0,0,0,0.1); transition: transform 0.2s; }
        .sms-item:hover { transform: translateY(-2px); }
        .sms-header { display: flex; justify-content: space-between; font-size: 12px; color: #6b7280; margin-bottom: 8px; border-bottom: 1px solid #f3f4f6; padding-bottom: 5px; }
        .sms-sender { font-weight: bold; color: #4b5563; font-size: 13px; }
        .sms-body { font-size: 14px; color: #1f2937; white-space: pre-wrap; word-wrap: break-word; line-height: 1.6; }
        .empty-msg { text-align: center; color: #9ca3af; margin-top: 50px; background: white; padding: 20px; border-radius: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div>
                <h2>لیست پیامک‌ها</h2>
                <div class="stats">
                    شناسه: <?php echo htmlspecialchars($user_id); ?> 
                    <?php if($sms_data): ?>
                    | تعداد کل: <?php echo number_format($sms_data['total_count']); ?> 
                    | آخرین بروزرسانی: <?php echo $sms_data['last_update']; ?>
                    <?php endif; ?>
                </div>
            </div>
            <a href="../user/index.php?id=<?php echo urlencode($user_id); ?>" class="back-btn">بازگشت به پنل</a>
        </div>
        
        <?php if(empty($messages)): ?>
            <div class="empty-msg">هیچ پیامکی یافت نشد یا هنوز درخواست ارسال نشده است.</div>
        <?php else: ?>
            <div class="sms-list">
                <?php foreach($messages as $index => $msg): ?>
                    <div class="sms-item">
                        <div class="sms-header">
                            <span class="sms-sender"><?php echo htmlspecialchars($msg['address']); ?></span>
                            <span dir="ltr"><?php echo htmlspecialchars($msg['date']); ?></span>
                        </div>
                        <div class="sms-body"><?php echo nl2br(htmlspecialchars($msg['body'])); ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>