<?php
$cache_file = 'list_cache.json';
// ... کدهای قبلی PHP ...
$all_users = [];
if (file_exists($cache_file)) {
    $json_content = file_get_contents($cache_file);
    $all_users = json_decode($json_content, true);
    if (!is_array($all_users)) $all_users = [];
}

// --- اضافه شده: زمان فعلی سرور به ثانیه ---
$server_time = time(); 
// -----------------------------------------

$total_users = count($all_users);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل ردیابی وضعیت کاربران</title>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <style>
        :root {
            --bg-color: #f3f4f6;
            --card-bg: #ffffff;
            --primary-color: #3b82f6;
            --online-color: #10b981;
            --offline-color: #ef4444;
            --deleted-color: #9ca3af;
            --text-color: #1f2937;
            --text-secondary: #6b7280;
        }
        body { font-family: 'Vazirmatn', Tahoma, sans-serif; background-color: var(--bg-color); color: var(--text-color); margin: 0; padding: 20px; direction: rtl; }
        .container { max-width: 800px; margin: 0 auto; }
        
        .dashboard { display: grid; grid-template-columns: repeat(4, 1fr); gap: 10px; margin-bottom: 30px; }
        .stat-card { background: var(--card-bg); padding: 15px; border-radius: 12px; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1); text-align: center; }
        .stat-value { font-size: 24px; font-weight: bold; }
        .stat-title { font-size: 12px; color: var(--text-secondary); }
        .text-blue { color: var(--primary-color); } .text-green { color: var(--online-color); } .text-red { color: var(--offline-color); } .text-gray { color: var(--deleted-color); }

        .users-list { display: flex; flex-direction: column; gap: 15px; }
        .user-card { background: var(--card-bg); padding: 20px; border-radius: 12px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); display: flex; align-items: center; justify-content: space-between; border-right: 5px solid transparent; transition: all 0.5s ease; }
        .user-card.online { border-right-color: var(--online-color); }
        .user-card.offline { border-right-color: var(--offline-color); }
        .user-card.deleted { border-right-color: var(--deleted-color); opacity: 0.7; background-color: #f9fafb; }
        
        .user-info { display: flex; align-items: center; gap: 15px; }
        .avatar { width: 50px; height: 50px; background-color: #e5e7eb; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #9ca3af; }
        .user-details h3 { margin: 0; font-size: 16px; font-weight: 700; }
        .user-details p { margin: 5px 0 0; font-size: 12px; color: var(--text-secondary); }
        
        .status-badge { padding: 6px 12px; border-radius: 20px; font-size: 12px; font-weight: bold; color: white; display: flex; align-items: center; gap: 5px; transition: background-color 0.5s ease; }
        .status-badge.online { background-color: var(--online-color); }
        .status-badge.offline { background-color: var(--offline-color); }
        .status-badge.deleted { background-color: var(--deleted-color); }
        
        .manage-btn { text-decoration: none; background-color: var(--primary-color); color: white; padding: 8px 16px; border-radius: 8px; font-size: 12px; margin-right: 10px; transition: background 0.3s; }
        .manage-btn:hover { background-color: #2563eb; }

        .footer { text-align: center; margin-top: 40px; font-size: 12px; color: #9ca3af; }
        @media (max-width: 600px) {
            .dashboard { grid-template-columns: 1fr 1fr; }
            .user-card { flex-direction: column; text-align: center; gap: 15px; }
            .user-card.online, .user-card.offline, .user-card.deleted { border-right: none; border-top: 5px solid; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="dashboard">
            <div class="stat-card"><div class="stat-title">تعداد کل نصب‌ها</div><div class="stat-value text-blue" id="count-total">0</div></div>
            <div class="stat-card"><div class="stat-title">کاربران آنلاین</div><div class="stat-value text-green" id="count-online">0</div></div>
            <div class="stat-card"><div class="stat-title">کاربران آفلاین</div><div class="stat-value text-red" id="count-offline">0</div></div>
            <div class="stat-card"><div class="stat-title">حذف شده‌ها</div><div class="stat-value text-gray" id="count-deleted">0</div></div>
        </div>

        <div class="users-list" id="users-container">
            <!-- لیست توسط JS پر می‌شود -->
        </div>
        
        <div class="footer">توسعه‌دهنده: ALEX CODER</div>
    </div>
       <script>
        const TIMEOUT_SECONDS = 20;
        
        // --- دریافت زمان سرور از PHP ---
        // این زمان ثابت است و بر اساس ساعت سرور محاسبه می‌شود
        const baseServerTime = <?php echo $server_time; ?>; 
        // زمانی که صفحه لود شد (برای محاسبه گذر زمان در کلاینت)
        const pageLoadClientTime = Math.floor(Date.now() / 1000);
        // -------------------------------

        function renderUsers(users) {
            const container = document.getElementById('users-container');
            let online = 0, offline = 0, deleted = 0;
            
            // محاسبه زمان "الان" بر اساس زمان سرور + گذر زمان در مرورگر
            const now = baseServerTime + (Math.floor(Date.now() / 1000) - pageLoadClientTime);

            let htmlBuffer = [];

            users.forEach(user => {
                const status = user.status || 'Offline';
                const timestamp = user.timestamp;
                
                // تبدیل زمان سرور (Y-m-d H:i:s) به ثانیه
                const serverTime = new Date(timestamp).getTime() / 1000;
                
                // محاسبه اختلاف زمان (هم اکنون منهای آخرین پینگ)
                const diff = now - serverTime;
                
                let realStatus = 'Offline';
                if (status === 'Deleted') {
                    realStatus = 'Deleted';
                } else if (status === 'Online' && diff <= TIMEOUT_SECONDS) {
                    realStatus = 'Online';
                }

                if(realStatus === 'Online') online++;
                else if(realStatus === 'Deleted') deleted++;
                else offline++;

                let statusText = 'آفلاین';
                let statusClass = 'offline';
                if (realStatus === 'Online') { statusText = 'آنلاین'; statusClass = 'online'; }
                if (realStatus === 'Deleted') { statusText = 'حذف شده'; statusClass = 'deleted'; }

                htmlBuffer.push(`
                <div class="user-card ${statusClass}">
                    <div class="user-info">
                        <div class="avatar">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                        </div>
                        <div class="user-details">
                            <h3>${user.user_id}</h3>
                            <p>آخرین فعالیت: ${timestamp}</p>
                        </div>
                    </div>
                    <div style="display: flex; align-items: center;">
                        <div class="status-badge ${statusClass}">
                            ${realStatus === 'Online' ? '<div class="dot"></div>' : ''}
                            ${statusText}
                        </div>
                        <a href="user/?id=${encodeURIComponent(user.user_id)}" class="manage-btn">مدیریت</a>
                    </div>
                </div>`);
            });

            container.innerHTML = htmlBuffer.join('');
            document.getElementById('count-total').innerText = users.length;
            document.getElementById('count-online').innerText = online;
            document.getElementById('count-offline').innerText = offline;
            document.getElementById('count-deleted').innerText = deleted;
        }

        function updateList() {
            fetch('list_cache.json?t=' + new Date().getTime())
                .then(res => res.json())
                .then(data => {
                    if(Array.isArray(data)) {
                        renderUsers(data);
                    }
                })
                .catch(err => console.log("Error updating list:", err));
        }

        const initialUsers = <?php echo json_encode($all_users); ?>;
        renderUsers(initialUsers);
        setInterval(updateList, 7);
    </script>
</body>
</html>